var SNAPIHelper = {}
var snAPIHelper = {}

snAPIHelper.common = new class {
    executeInFrames(script) {
        var frames = document.getElementsByTagName("iframe");
        var message = {name: "exec", message: { script: script }};

        for (var index = 0; index < frames.length; index++) {
            frames[index].contentWindow.postMessage(message, "*");
        }
    }
}

// Message listener for relaying callbacks/events to iFrames
window.addEventListener('message', function(e) {
    console.log("Test", e);
    if (typeof e.data === "object") {
        if (e.data.name == "exec") {
            eval(e.data.message.script);
        }
    }
}, false);


// MARK: -

SafariRemoteNotification = class {
	
}

window.oldNotification = window.Notification;

window.Notification = function() {
    window.webkit.messageHandlers.notifications.postMessage([arguments[0], arguments[1]]);
  const notificationEnabled = true;
  return notificationEnabled ? new window.oldNotification(...arguments) : {};
};

Object.defineProperty(Notification, 'permission', {
  get() {
    return 'granted';
  }
});

Notification.requestPermission = (callback) => {
  if (typeof callback === 'function') {
      callback('granted');
  }
  return Promise.resolve(Notification.permission);
};

window.safari = {}
window.safari.pushNotification = new SafariRemoteNotification();

// MARK: -

snAPIHelper.autoFill = new class {
	constructor() {
		window.addEventListener('DOMContentLoaded', function() {
			var style = document.createElement('style');
			style.innerHTML = '\
			.SNAutofill {\
				background-color: #ffffdd !important;\
			}\
			';
			document.head.appendChild(style);
		}, false);
		
		this.KEYCODE_ARROW_DOWN = 40;
	}
	
	autoFill(username, password) {
		if (typeof this.loginFields !== "undefined") {
			
			this.loginFields["username"].value = username;
			
			this.dispatchKeyboardEvent(this.loginFields["username"], "keydown", this.KEYCODE_ARROW_DOWN);
			this.dispatchKeyboardEvent(this.loginFields["username"], "keyup", this.KEYCODE_ARROW_DOWN);

			this.loginFields["password"].value = password;
			
			this.dispatchKeyboardEvent(this.loginFields["password"], "keydown", this.KEYCODE_ARROW_DOWN);
			this.dispatchKeyboardEvent(this.loginFields["password"], "keyup", this.KEYCODE_ARROW_DOWN);
			
			this.loginFields["username"].classList.add("SNAutofill");
			this.loginFields["password"].classList.add("SNAutofill");
		}
		
        snAPIHelper.common.executeInFrames("snAPIHelper.autoFill.autoFill('"+username+"', '"+password+"'");
	}
	
	domUpdated() {
		var loginFields = this.getLoginFields();
		if (typeof loginFields !== "undefined") {
			if (typeof this.loginFields !== "undefined") {
				if (loginFields["password"] === this.loginFields["password"]) {
					return;
				}
			}
			window.webkit.messageHandlers.autoFill.postMessage(["onLoginFound", { "username": loginFields["username"].value, "password": loginFields["password"].value }]);
			loginFields["username"].addEventListener('input', this.onUsernameChange, false);
			loginFields["password"].addEventListener('input', this.onPasswordChange, false);
			loginFields["username"].addEventListener("focus", this.onUsernameFocused, false);
			loginFields["username"].addEventListener("blur", this.onUsernameBlurred, false);
			loginFields["password"].addEventListener("focus", this.onPasswordFocused, false);
			loginFields["password"].addEventListener("blur", this.onPasswordBlurred, false);
			loginFields["username"].addEventListener("keyup", this.onKeyUp, false);
			loginFields["password"].addEventListener("keyup", this.onKeyUp, false);
		}
		this.loginFields = loginFields;
	}
	
	getLoginFields() {
		var passwordFields = this.allPasswordFields();
		var passwordLength = passwordFields.length;
		var loginGroups = [];
		while (passwordLength--) {
			var curPasswordField = passwordFields[passwordLength];
			var parentForm = this.parentForm(curPasswordField);
			
			if (parentForm) {
				var possibleUserField = this.possibleUserField(parentForm, curPasswordField);
				if (possibleUserField) {
					loginGroups.push([possibleUserField, curPasswordField]);
				}
			} else {
				var possibleUserField = this.possibleUserField(document, curPasswordField);
				if (possibleUserField) {
					loginGroups.push([possibleUserField, curPasswordField]);
				}
			}
		}
		
		if (loginGroups.length > 1) {
			var loginGroupLength = loginGroups.length;
			for (var i = 0; i < loginGroupLength; i++) {
				if (window.getComputedStyle(loginGroups[i][1]).position.toLowerCase() != "fixed") {
					if (loginGroups[i][1].offsetParent !== null && loginGroups[i][0].offsetParent !== null ) {
						return { "username": loginGroups[i][0], "password": loginGroups[i][1] }
					}
				}
			}
			
			for (var i = 0; i < loginGroupLength; i++) {
				if (window.getComputedStyle(loginGroups[i][1]).position.toLowerCase() != "fixed") {
					if (loginGroups[i][1].offsetParent !== null || loginGroups[i][0].offsetParent !== null ) {
						return { "username": loginGroups[i][0], "password": loginGroups[i][1] }
					}
				}
			}
		} else if (loginGroups.length == 1) {
			return { "username": loginGroups[0][0], "password": loginGroups[0][1] }
		}
	}
	
	possibleUserField(parent, passwordField) {
		var inputFieldsByCategory = {};
		var inputs = parent.getElementsByTagName('input');
		var passwordFieldIndex = [].slice.call(inputs).indexOf(passwordField);
		var inputsByCategory = {};
		for (var i = 0; i < inputs.length; i++) {
			if (inputs[i] === passwordField || (passwordFieldIndex - i) < 0) {
				continue;
			}
			
			var fieldType = (inputs[i].hasAttribute("type") ?
							 inputs[i].getAttribute("type").toLowerCase() :
							 inputs[i].type);
			
			if (fieldType == "text"  ||
				fieldType == "email" ||
				fieldType == "url"   ||
				fieldType == "tel"   ||
				fieldType == "number") {
				if (typeof inputsByCategory[fieldType] === "undefined") {
					inputsByCategory[fieldType] = [];
				}
				
				inputsByCategory[fieldType].push([inputs[i], passwordFieldIndex - i]);
			}
		}
		
		if (typeof inputsByCategory["email"] !== "undefined") {
			return inputsByCategory["email"].sort(this.compare)[0][0];
		} else if (typeof inputsByCategory["text"] !== "undefined") {
			return inputsByCategory["text"].sort(this.compare)[0][0];
		}
	}
	
	allPasswordFields() {
		var inputs = document.getElementsByTagName('input');
		var	length = inputs.length;
		var	fields = [];
		while (length--) {
			if (inputs[length].type === 'password') {
				fields[fields.length] = inputs[length];
			}
		}
		return fields;
	}
	
	parentForm(element) {
		while (element.parentNode) {
			if (element.parentNode.nodeName.toLowerCase() === 'form') {
				return element.parentNode;
			}
			element = element.parentNode;
		}
	}
	
	compare(inputA, inputB) {
	  return (inputA[1] > inputB[1]);
	}
	
	onUsernameFocused(event) {
		if (snAPIHelper.autoFill.loginFields["username"].classList.contains("SNAutofill")) {
			return
		}
		var viewportOffset = event.target.getBoundingClientRect();
		window.webkit.messageHandlers.autoFill.postMessage(["onUsernameFocused", {"top": viewportOffset.bottom, "left": viewportOffset.left}]);
	}
	
	onUsernameBlurred(event) {
		window.webkit.messageHandlers.autoFill.postMessage(["onUsernameBlurred"]);
	}
	
	onPasswordFocused(event) {
		if (snAPIHelper.autoFill.loginFields["password"].classList.contains("SNAutofill") && snAPIHelper.autoFill.loginFields["password"].value.length != 0) {
			return
		}
		var viewportOffset = event.target.getBoundingClientRect();
		window.webkit.messageHandlers.autoFill.postMessage(["onPasswordFocused", {"top": viewportOffset.bottom, "left": viewportOffset.left}]);
	}
	
	onPasswordBlurred(event) {
		window.webkit.messageHandlers.autoFill.postMessage(["onPasswordBlurred"]);
	}
	
	onUsernameChange(event) {
		var viewportOffset = event.target.getBoundingClientRect();
		snAPIHelper.autoFill.loginFields["username"].classList.remove("SNAutofill");
		window.webkit.messageHandlers.autoFill.postMessage(["onUsernameChange", event.target.value, {"top": viewportOffset.bottom, "left": viewportOffset.left}]);
	}
	
	onPasswordChange(event) {
		var viewportOffset = event.target.getBoundingClientRect();
		snAPIHelper.autoFill.loginFields["password"].classList.remove("SNAutofill");
		window.webkit.messageHandlers.autoFill.postMessage(["onPasswordChange", event.target.value, {"top": viewportOffset.bottom, "left": viewportOffset.left}]);
	}
	
	onKeyUp(event) {
		if (event.keyCode === 13) {
			window.webkit.messageHandlers.autoFill.postMessage(["onKeyUp", 13]);
			event.preventDefault();
		} else if (event.keyCode === 27) {
			window.webkit.messageHandlers.autoFill.postMessage(["onKeyUp", 27]);
		} else if (event.key == "ArrowUp") {
			window.webkit.messageHandlers.autoFill.postMessage(["onKeyUp", -1]);
		} else if (event.key == "ArrowDown") {
			window.webkit.messageHandlers.autoFill.postMessage(["onKeyUp", 1]);
		}
	}
	
	dispatchKeyboardEvent(element, eventName, keyCode) {
	  var event = document.createEvent("KeyboardEvent");
	  event.initKeyboardEvent(eventName, true, true, window, 0, 0, 0, 0, 0, keyCode);
	  element.dispatchEvent(event);
	}
}

// DOM update observer
snAPIHelper.observer = new MutationObserver(function(mutationsList, observer) {
    snAPIHelper.autoFill.domUpdated();
});
snAPIHelper.observer.observe(document, { attributes: true, childList: true, subtree: true });
